<?php
/*
Plugin Name: Custom Login Page
Description: Customize the WordPress login page with a dynamic site logo and link.
Version: 1.1
Author: Jayesh Patil | <a href="https://imjay.in/wordpress-plugins/custom-login-page/" target="_blank">Visit: imjay.in</a>
*/

function custom_login_styles() {
    // Get the Site Logo URL dynamically
    $custom_logo_id = get_theme_mod('custom_logo');
    $logo_url = $custom_logo_id ? wp_get_attachment_image_url($custom_logo_id, 'full') : '';

    ?>
    <style type="text/css">
        body.login {
            background-color: #f3f4f6;
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
            margin: 0;
            font-family: Arial, sans-serif;
            overflow: hidden;
            position: relative;
        }

        #login {
            width: 400px;
            padding: 40px;
            background-color: #ffffff;
            border-radius: 16px;
            box-shadow: 0 8px 30px rgba(0,0,0,0.1);
            text-align: center;
            position: relative;
            z-index: 1;
        }

        #login h1 a {
            background-image: url('<?php echo esc_url($logo_url); ?>');
            background-size: contain;
            width: auto;
            height: 100px;
            margin-bottom: 20px;
            display: block;
            
            margin-left: auto;
            margin-right: auto;
        }

        .login form {
            background: none;
            box-shadow: none;
            padding: 0;
            margin-top: 20px;
        }

        .login label {
            font-weight: 600;
            color: #333;
            display: block;
            margin-bottom: 8px;
            text-align: left;
            font-size: 14px;
        }

        input[type="text"], input[type="password"] {
            width: 100%;
            padding: 12px;
            margin-bottom: 20px;
            border: 1px solid #ddd;
            border-radius: 10px;
            box-sizing: border-box;
            background-color: #f9f9f9;
            transition: all 0.3s;
            font-size: 14px;
        }

        input[type="text"]:focus, input[type="password"]:focus {
            border-color: #0073aa;
            outline: none;
            background-color: #ffffff;
            box-shadow: 0 0 6px rgba(0, 115, 170, 0.3);
        }

        input[type="submit"] {
            background-color: #0073aa;
            color: #ffffff;
            border: none;
            border-radius: 10px;
            padding: 12px;
            cursor: pointer;
            width: 100%;
            font-weight: bold;
            margin-top: 10px;
            font-size: 14px;
            transition: background-color 0.3s, transform 0.2s;
        }

        input[type="submit"]:hover {
            background-color: #005b7f;
            transform: translateY(-2px);
        }

        .login #backtoblog, .login #nav {
            margin-top: 15px;
            text-align: center;
        }

        .login #backtoblog a, .login #nav a {
            color: #0073aa;
            text-decoration: none;
            font-size: 13px;
            margin: 0 5px;
        }

        .login #backtoblog a:hover, .login #nav a:hover {
            color: #005b7f;
        }

        /* Subtle Background Pattern */
        body.login:before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-image: linear-gradient(135deg, rgba(0, 115, 170, 0.05) 25%, transparent 25%), 
                              linear-gradient(225deg, rgba(0, 115, 170, 0.05) 25%, transparent 25%),
                              linear-gradient(45deg, rgba(0, 115, 170, 0.05) 25%, transparent 25%),
                              linear-gradient(315deg, rgba(0, 115, 170, 0.05) 25%, transparent 25%);
            background-size: 30px 30px;
            z-index: 0;
        }
    </style>
    <?php
}
add_action('login_enqueue_scripts', 'custom_login_styles');

// Set the logo link to your site's homepage
function custom_login_logo_url() {
    return home_url();
}
add_filter('login_headerurl', 'custom_login_logo_url');

// Set the logo title text
function custom_login_logo_title() {
    return get_bloginfo('name');
}
add_filter('login_headertext', 'custom_login_logo_title');